/** 
 * This Class contains methods for storing and retrieving a 4*4 matrix 
 * of joint probability distribution values along each branch
 *
 * @author Vivek Jayaswal
 *
 */
 
public class BranchDetails {	
	double[][] jointProbability = new double[4][4];
	double[] lagrangeMult = new double[8];
	
	BranchDetails() {
		
	}
	
	BranchDetails(double[][] d) {
		for(int i=0; i<4; i++) {
			for(int j=0; j<4; j++) {
				jointProbability[i][j] = d[i][j];
			}
		}			
	}
	
	/* Rows represent values at nodeA's parent and the columns represent
	 * values at nodeA
	 */
	public void setJointProbability() {
		for(int i=0; i<4; i++) {
			for(int j=0; j<4; j++) {
				if(i == j) jointProbability[i][j] = 1.0/8.0;
				else jointProbability[i][j] = 1.0/24.0;
			}
		} 
			
	}
	
	public void setJointProbability(int x0, int x1, double sum) {
		System.out.println("ALOHA");
		jointProbability[x0][x1] = sum;
	}
	
	public void setJointProbability(double d[][]) {
		for(int i=0; i<4; i++) {
			for(int j=0; j<4; j++) {
				jointProbability[i][j] = d[i][j];
				if(jointProbability[i][j] <= 0) {
					//System.out.println("Set" + jointProbability[i][j]);	
					jointProbability[i][j] = 0.00000001; //Code added on 18-Aug-06
				}
			}
		}	
	}		
	
	public void setJointProbability(double d[][], double[] lagrange) {
		for(int i=0; i<4; i++) {
			for(int j=0; j<4; j++) {
				jointProbability[i][j] = d[i][j];
			}
		}
		
		setLagrangeMultipliers(lagrange);
	}
	
	public double[][] getJointProbability() {
		return jointProbability;
	}
	
	public void setLagrangeMultipliers(double[] mult) {
		for(int i=0; i<8; i++) {
			lagrangeMult[i] = mult[i];
		}		
	}	
	
	public double[] getLagrangeMultipliers() {
		return lagrangeMult;
	}	
	
}