/** 
 * This Class contains methods for storing and retrieving RiXi values for each
 * internal node for all 4 nucleotide types
 *
 * @author Vivek Jayaswal
 * @version 1.0
 */
 
public class InternalNodeRiXi {	
	double siteValueA;		//nucleotide adenine
	double siteValueC;		//nucleotide cytosine
	double siteValueG;		//nucleotide guanine
	double siteValueT;		//nucleotide thymine

	void setNucleotideA(double value) {
		siteValueA = value;
	}	

	void setNucleotideC(double value) {
		siteValueC = value;
	}	

	void setNucleotideG(double value) {
		siteValueG = value;
	}	

	void setNucleotideT(double value) {
		siteValueT = value;
	}	

	double getNucleotideA() {
		return siteValueA;
	}	

	double getNucleotideC() {
		return siteValueC;
	}	

	double getNucleotideG() {
		return siteValueG;
	}	

	double getNucleotideT() {
		return siteValueT;
	}	
	
	double[] getNucleotides() {
		double array[] = new double[4];
		
		array[0] = siteValueA;
		array[1] = siteValueC;
		array[2] = siteValueG;
		array[3] = siteValueT;
		
		return array;
	}
}
