#ifndef __DATA_INTERFACE_H__
#define __DATA_INTERFACE_H__

#include "pwms.h"

typedef struct {
  int len;
  iLetter *entry;
} iLetterVec;


typedef struct { // a structure for a character sequence
  char *header;
  int header_len;
  charVec body;		/* excluding white space at the moment */
} cSeqStruct;

typedef struct { // a vector of character sequences
  cSeqStruct * entry;
  int len;
} cSeqVec;


typedef struct { // a structure for a iLetter sequence
  char *header;
  int header_len;
  iLetterVec body;
  int num_gaps; // how many gaps are in that sequence
  unsigned short *gap_len; // [length of this sequence]
                           // each entry tells how many symbols were missing
                           // immediately before it. 0 means no symbol missed
		           // 2 means that the 2 symbols before it were missing (hence a gap)
} iSeqStruct;

typedef struct { // a vector of iLetter sequences
  iSeqStruct * entry;
  int len;
  char *strip;	/* for the letter code */
  int report_gaps; // 1 = yes, 0 = no
} iSeqVec;

/*
typedef struct { // for storing a contiguous segment of the sequence
  iLetterVec body;
  int startPos; // starting position of chunk along the sequence
} chunkStruct;
	
typedef struct { // a chunks representation of the sequence
  char *header;
  int header_len;
  chunkStruct *chunks;
  int num_chunks;
  int total_len; // "solid" residues, gaps not included
} chunksSeq;

typedef struct { // a vector of chunked-sequences
  chunksSeq * entry;
  int len;
  char *strip;
  unsigned int id; // a global identifier of the sequences vector used to associate other data with it (obsolete?)
} chunksSeqVec;
*/

typedef struct {	//a sequence potentially having gaps in some positions
	char *header;
  	int header_len;
	iLetterVec body;	//	the sequence, with gaps represented by character GAP_CHAR
	int numChunks;	//	number of contiguous non-gapped portions
	int* chunkOffsets;	//	chunkOffsets has numChunks entries, which offset into the non-gapped portions
	int* chunkLens;		//	chunkLens has numChunks entries, which give the length of the non-gapped portions
	//	the total length of the gapped sequence (including the gaps) is body.len
	//	the total length of "solid" residues is the sum of entries of chunkLens 
} gappedSeq;	//	Added by Anand

typedef struct	{	//a vector of gappedSeq's
	gappedSeq* entry;
	int len;
	char *strip;
	unsigned int id;
} gappedSeqVec;

cSeqVec read_seqs(char *input_file_name);

iSeqVec filter_sequences(cSeqVec c_seqs, char strip[], int report_gaps);

double *nucl_frequency(iSeqVec seqs, int please_print, FILE * outfile);

void print_a_line(iSeqStruct i_seq, char *strip, int at, int len, int padding, int header);

unsigned int gappedSeqVecTotalLen(gappedSeqVec set);
//unsigned int chunkSeqVecTotalLen(chunksSeqVec set);

gappedSeqVec iLetterVec2gappedSeqVec(iLetterVec block, gappedSeqVec moldSet);
//chunksSeqVec iLetterVec2chunksSeqVec(iLetterVec block, chunksSeqVec moldSet);
	
iLetterVec gappedSeq2iLetterVec(gappedSeq cSeq);
//iLetterVec chunkSeq2iLetterVec(chunksSeq cSeq);

void iLetterVec2gappedSeq(iLetterVec block, gappedSeq *cSeq);
//void iLetterVec2chunks(iLetterVec block, chunksSeq *cSeq);

gappedSeqVec alloc_gappedSeqVec(int len);
//chunksSeqVec alloc_chunksSeqVec(int len);

iLetterVec alloc_iLetterVec(int len);

void realloc_iLetterVec(iLetterVec *vec, int len);

void free_c_seqs(cSeqVec c_seqs);

void free_i_seqs(iSeqVec i_seqs);

void free_gappedSeqVec(gappedSeqVec seqs);
//void free_chunksSeqVec(chunksSeqVec seqs);

void free_gappedSeq(gappedSeq chunks);
//void free_chunksSeq(chunksSeq chunks);

// decompose a sequence with respect to gaps
gappedSeqVec chunk_decomp(iSeqVec i_seqs, FILE *outfile);

gappedSeqVec getChunkDS(char *fileName, char *strip, FILE *outfile);

iLetterVec readFile2iLetterVec(char *fileName, char *strip, FILE *outfile);

void permuteChunk(iLetterVec chunk, int *perm);

void permuteAllSeqs(gappedSeqVec set);

// print the given site to the given output
//void PrintSite(chunksSeqVec *set, int siteSeqID, int chunkID, int siteLeftPos, Boolean siteRev, double siteScore, int pwm_width, FILE *output);
void printSite(gappedSeqVec *set, int siteSeqID, int chunkID, int leftChunkOffset, Boolean siteRev, double siteScore, motif_Struct motif, int motifConfig, int motifSpan, FILE *output);

//chunksSeqVec gappedSeqVec2chunksSeqVec(gappedSeqVec seqVec);
//chunksSeq gappedSeq2chunksSeq(gappedSeq seq);
//gappedSeqVec chunksSeqVec2gappedSeqVec(chunksSeqVec cSeqVec);
//gappedSeq chunksSeq2gappedSeq(chunksSeq cSeq);

#endif