/* randist/hyperg.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 James Theiler, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// code moved around by Jeff Garretson so that I didn't need the entirety of the GSL (which I wasn't sure I could compile for this project)

// this code was originally in the GSL, but was taken out and modified to no longer use the GSL's weird functions

#include <math.h>
#include <stdio.h>
#include "lnchoose.h"

double gsl_sf_lnfact(const unsigned int n);

double gsl_sf_lnchoose(unsigned int n, unsigned int m)
{

  if(m > n) {
    fprintf(stdout, "m can't be greater than n!!\n");
  }
  else if(m == n || m == 0) {
    return 0;
  }
  else {
	  double nf,mf,nmmf;
	  //if(m*2 > n)
		//  m = n-m;
	  nf = gsl_sf_lnfact(n);
	  mf = gsl_sf_lnfact(m);
	  nmmf = gsl_sf_lnfact(n-m);

	  return nf-mf-nmmf;
  }
}

double gsl_sf_lnfact(const unsigned int n)
{
  if(n <= GSL_SF_FACT_NMAX){
	  return log(fact_table[n].f);
  }
  else {
	  double factorial = 0;
	  int i;
	  for(i = 2; i <= n; i++){
		  factorial += log(i);
	  }
	  return factorial;
  }
}
