#ifndef __MARKOV_H__
#define __MARKOV_H__

typedef struct { // Markov model
  int order;
  double **transitionP;    // [past size (<= order)][past*ALPHAS+present]
  double **logTransitionP; // log of the transition probability (precomputed for speed)
} MarkovModelType;



MarkovModelType trainMarkovModel(iLetterVec trainData, int order, double pseudoCount, int scanMode);

Boolean writeMarkovModelToFile(MarkovModelType MM, char* fname);

MarkovModelType readMarkovModelFromFile(char* fname);

iLetterVec genMarkovBlock(MarkovModelType MM, int len);

double getMarkovLklhd(MarkovModelType markovModel, iLetter *string, int loc, int len);

realVec getPosMarkovLklhds(MarkovModelType markovModel, iLetterVec string);

void freeMarkovModel(MarkovModelType MM);

#endif
