#ifndef __MISC_FUNCTIONS_H__
#define __MISC_FUNCTIONS_H__

#include "data_interface.h"
#include "my_types.h"

#define MIN2(X, Y) (((X) > (Y)) ? (Y) : (X))
#define MAX2(X, Y) (((X) > (Y)) ? (X) : (Y))
//#define PRINT2(asprintfCommand) {(asprintfCommand >= 0) ? {printf("%s", ASPRINTF_STR); fprintf(outputFile, "%s", ASPRINTF_STR); free(ASPRINTF_STR); : ERROR(("Error in asprintf"))}
#define ERROR(printfMessage) {printf("\nAbborting: "); printf printfMessage; printf("\n"); exit(0);}  // Print the message and abort. The printfMessage ***must*** include parentheses!


int *rand_perm_prealloc(int *perm, int n); //Returns a random permutation in S_n w/o worrying about memory allocation

intVec multiset_multiplicities(realVec mset); // Returns multiplicities of real valued multiset

double myNaN(); // return a NaN

int multinomialDraw(double *pmf, int nItems);

double compMean(realVec sample);

double compStd(realVec sample);

void errorMessage(char *message);

void *my_realloc(void *ptr, size_t size);

long my_atol(char *string);

double my_atod(char *string);

void checkRangeD(double x, double minX, double maxX, char *nameX);

void checkRangeI(int x, int minX, int maxX, char *nameX);

void setTRUE(Boolean *p, int from, int len);

int findStringOnce(char *string, stringVec strings);

int findString(char *string, stringVec strings);

intVec findStringInStringVec(char *string, stringVec strings);

char *allocAndStrCpy(char *str);

char *allocAndStrCat(char *str1, char *str2);

double *allocAndSetD(double x);


iLetterVec getReverseComplement(const iLetterVec seq);

gappedSeq getSeqReverseComplement(const gappedSeq seq);

#endif
