#ifndef __MY_TYPES_H__
#define __MY_TYPES_H__

typedef unsigned char iLetter;
extern const iLetter GAP_CHAR;

typedef long long int64, int64VecEntry;
typedef struct {int len; int64VecEntry * entry;} int64Vec;

typedef int intVecEntry;
typedef struct {int len; intVecEntry * entry;} intVec;

typedef double realVecEntry;
typedef struct {int len; realVecEntry * entry;} realVec;

typedef struct {int len; char **entry;} stringVec;
typedef struct {int len; char *entry;} charVec;

int64Vec alloc_int64Vec(int);			//Returns an allocated int64Vec
realVec alloc_realVec(int);             // Returns an allocated realVec
intVec alloc_intVec(int);               // Returns an allocated intVec
void realloc_intVec(intVec *iVec, int len);

intVec iArray2intVec(int *, int);       // Returns an intVec equivalent to an int array
realVec dArray2realVec(double *, int);  // Returns a realVec equivalent to a double array
realVec fArray2realVec(float *, int);   // Returns a realVec equivalent to a float array
 

int realVecEntryComp(const realVecEntry *,const realVecEntry *); // compares 2 realVecEntry (used by qsort)

typedef enum {FALSE=0, TRUE} Boolean;

#define FREE_ATOMS_VEC(vec) if (vec.len > 0) {free(vec.entry); vec.len=0;}

#endif