#ifndef __PWMS_H__
#define __PWMS_H__

typedef struct {
  double **entry;            // actual PWM entries
  double *logFreqs;          // log of the frequencies [pos*ALPHAS + i]
  int width;
  unsigned int minNextGap;      // minimal gap to next block
  unsigned int maxNextGap;      // maximal gap to next block
} PWM_Struct;

typedef struct {
  char *header;              // The header as a string
  unsigned int id;           // a global identifier of the PWM used to associate other data with it
  double *siteThreshold;     // not allocated when not set
  PWM_Struct *pwms;
  unsigned int nPWMs;
  //int width;				// this only makes sense for "rigid" motifs
} motif_Struct;

typedef struct {
  int len;
  motif_Struct * entry;
} motifsVec;



motifsVec read_motifs(char * wmfile);      // reads the next motif from a file



// randomly permutes the weight matrix
void permute_motif (motif_Struct *motif);
// void permute_wm(motif_Struct *motif); // ******* needs to be rewritten not valid any more ******
double sitePwmScore(iLetter *site, double *pwm, int width);

// double get_sitePercentThresh(PWM_Struct pwm);
void set_siteThreshold(motif_Struct *motif);
void set_threshGenerationData(double sitePercentThreshValue, unsigned int siteThreshTrainSizeseValuet, int siteThresholdBlockType, int siteThresholdScanDirValue);

// Reads the thresholds from a file and sets the appropriate slots of motifs
void set_siteThresholdsFromFile(char *thresholdsFileName, motifsVec motifs);

void set_pwmPC(double pc);

#endif
