/*
 * The author of this software is Catherine Loader, c@herine.net
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose without fee is hereby granted, with the exceptions noted below,
 * and provided that this entire notice is included in all copies of any
 * software which is or includes a copy or modification of this software
 * and in all copies of the supporting documentation for such software.
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHOR NOR LUCENT TECHNOLOGIES
 * MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
 * MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */
/*
 * This function evaluates bd0(x,np) = x log(x/np) + np - x
 * in a manner that should be stable (with small relative error)
 * for all x and np.
 * In particular for x/np close to 1 direct evaluation fails,
 * and evaluation is based on the Taylor series of log((1+v)/(1-v))
 * with v = (x-np)/(x+np).
 *
 * Inputs x and np should be positive -- I don't check this.
 */

#include <math.h>
#include "dbinom.h"

double bd0(x,np)
NTYPE x;
double np;
{ double ej, s, s1, v;
  int j;
  if (fabs(x-np)<0.1*(x+np))
  {
    s = (x-np)*(x-np)/(x+np);
    v = (x-np)/(x+np);
    ej = 2*x*v; v = v*v;
    for (j=1; ;++j)
    { ej *= v;
      s1 = s+ej/((j<<1)+1);
#ifdef TESTBD0
if (s1==s) printf("Series, final j = %d\n",j);
#endif
      if (s1==s) return(s1);
      s = s1;
    }
  }
#ifdef TESTBD0
printf("using direct\n");
#endif
  return(x*log(x/np)+np-x);
}
