/*
 * The author of this software is Catherine Loader, c@herine.net
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose without fee is hereby granted, with the exceptions noted below,
 * and provided that this entire notice is included in all copies of any
 * software which is or includes a copy or modification of this software
 * and in all copies of the supporting documentation for such software.
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHOR NOR LUCENT TECHNOLOGIES
 * MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
 * MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */
/*
 * NTYPE is used for integer and degrees-of-freedom type arguments.
 * For 32-bit integers, the maximum n is 2^31-1=2147483647.
 * If larger n is required, or for fractional r or df in
 * the dgamma, dchisq and other functions, NTYPE must be double.
 */
typedef double NTYPE;

#ifndef PI
#define PI  3.141592653589793238462643
#endif
#define PIx2 6.283185307179586476925286        /* 2*pi */
#define HF_LG_PIx2  0.918938533204672741780329736406    /* 0.5*log(2*pi) */

#define LOG_ZERO -1e100
#define D_0 ((give_log) ? LOG_ZERO : 0.0)
#define D_1 ((give_log) ? 0.0 : 1.0)
#define DEXP(x)   ((give_log) ? (x) : exp(x))
#define FEXP(f,x) ((give_log) ? -0.5*log(f)+(x) : exp(x)/sqrt(f))
#define STIRLERR(n) stirlerr(n)
#define FORCE_INT(x) floor(x+0.5)

#define NOT_NNEG_INT(x) ((x<0.0) || (fabs((x) - floor((x)+0.5)) > 1e-7))
#define INVALID_PARAMS 0.0

extern double stirlerr(), bd0();
extern double dbinom_raw(), dpois_raw();
extern double dbinom(), dpois(), dnbinom(), dbeta(), dgamma(), dt(), df(), dhyper();
