typedef struct { // Markov model
  int order;
  double **transitionP;    // [past size (<= order)][past*ALPHAS+present]
  double **logTransitionP; // log of the transition probability (precomputed for speed)
} MarkovModelType;



MarkovModelType trainMarkovModel(iLetterVec trainData, int order, double pseudoCount);

iLetterVec genMarkovBlock(MarkovModelType MM, int len);

double getMarkovLklhd(MarkovModelType markovModel, iLetter *string, int loc, int len);

void freeMarkovModel(MarkovModelType MM);
