typedef struct {
  iLetterVec trainData; // training data for the block methods
  //  MCmodelType randModel;// the MC model (isn't really used since it's set globally)
  MarkovModelType markovModel;    // the markov null model
  bootBlocksStruct bootBlocks;    // for the bootstrap blocks
} RandomDsCreatorType; // attach a pointer to this one to an extended dataset structure



void gen_mc_2ds(chunksSeqVec moldSet1, chunksSeqVec moldSet2, RandomDsCreatorType *rdc1, 
		RandomDsCreatorType *rdc2, PWM_Struct pwm, chunksSeqVec *rSet1, chunksSeqVec *rSet2);

chunksSeqVec gen_mc_ds(chunksSeqVec moldSet, RandomDsCreatorType *rdc, PWM_Struct pwm);

iLetterVec gen_MCblock(RandomDsCreatorType *rdc, PWM_Struct pwm, int len);

int set_mcModel(char *mc_modelName, char **parameters, int nParms);

RandomDsCreatorType *alloc_RandomDsCreator(iLetterVec trainData);

void free_RandomDsCreatorType(RandomDsCreatorType *rdc);

Boolean blockMCmodel();
