#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include "my_types.h"
#include "misc_functions.h"



realVec alloc_realVec(int len)
     // Returns an allocated realVec
{
  realVec rVec;

  if (len > 0)
    assert( rVec.entry = (realVecEntry *) calloc(len, sizeof(realVecEntry)) );
  else
    rVec.entry = NULL;
  rVec.len = len;

  return rVec;
}


intVec alloc_intVec(int len)
     // Returns an allocated intVec
{
  intVec iVec;

  if (len > 0)
    assert( iVec.entry = (intVecEntry *) calloc(len, sizeof(intVecEntry)) );
  else
    iVec.entry = NULL;
  iVec.len = len;

  return iVec;
}


void realloc_intVec(intVec *iVec, int len)
     // Reallocs an intVec
{

  if (len > 0)
    assert( iVec->entry = (intVecEntry *) realloc(iVec->entry, len*sizeof(intVecEntry)) );
  else if (iVec->entry != NULL)
    free(iVec->entry);
  iVec->len = MAX2(0, len);
}


intVec iArray2intVec(int *vec, int len)
     // Returns an intVec equivalent to an int array
{
  intVec iVec;
  int i;

  iVec = alloc_intVec(len);
  for (i = 0; i < len; i++)
    iVec.entry[i] = vec[i];

  return iVec;
}


realVec dArray2realVec(double *vec, int len)
 // Returns a realVec equivalent to a double array
{
  realVec rVec;
  int i;

  rVec = alloc_realVec(len);
  for (i = 0; i < len; i++)
    rVec.entry[i] = vec[i];

  return rVec;
}


realVec fArray2realVec(float *vec, int len)
 // Returns a realVec equivalent to a float array
{
  realVec rVec;
  int i;

  rVec = alloc_realVec(len);
  for (i = 0; i < len; i++)
    rVec.entry[i] = vec[i];

  return rVec;
}


int realVecEntryComp(const realVecEntry *e1,const realVecEntry *e2)
     /*
       compares two realVecEntry entries which is needed for qsort()
      */
{    
      return (*e1<*e2)? -1:(*e1>*e2)? 1:0;
}
