typedef int intVecEntry;
typedef struct {int len; intVecEntry * entry;} intVec;

typedef double realVecEntry;
typedef struct {int len; realVecEntry * entry;} realVec;

typedef struct {int len; char **entry;} stringVec;
typedef struct {int len; char *entry;} charVec;

realVec alloc_realVec(int);             // Returns an allocated realVec
intVec alloc_intVec(int);               // Returns an allocated intVec
void realloc_intVec(intVec *iVec, int len);

intVec iArray2intVec(int *, int);       // Returns an intVec equivalent to an int array
realVec dArray2realVec(double *, int);  // Returns a realVec equivalent to a double array
realVec fArray2realVec(float *, int);   // Returns a realVec equivalent to a double array
 

int realVecEntryComp(const realVecEntry *,const realVecEntry *); // compares 2 realVecEntry (used by qsort)

typedef enum {FALSE=0, TRUE} Boolean;

#define FREE_ATOMS_VEC(vec) if (vec.len > 0) {free(vec.entry); vec.len=0;}

#define __my_types__ 1
