typedef struct {
  char *header;              // The header as a string
  double **entry;            // actual PWM entries
  double *logFreqs;          // log of the frequencies [pos*ALPHAS + i]
  double **reverseCompEntry; // reverse complemented
  double *logFreqsRC;        // log of frequencies of RC matric [pos*ALPHAS + i]
  int width;
  unsigned int id;           // a global identifier of the PWM used to associate other data with it
  double *siteThreshold;     // not allocated when not set
} PWM_Struct;

typedef struct {
  int len;
  PWM_Struct * entry;
} PWMsVec;



PWMsVec read_pwms(char * wmfile);      // read the weight matrix from a file



// randomly permutes the weight matrix
void permute_wm(PWM_Struct *pwm);

double sitePwmScore(iLetter *site, double *pwm, int width);

double get_sitePercentThresh(PWM_Struct pwm);
void set_siteThreshold(PWM_Struct *pwm);
void set_threshGenerationData(double sitePercentThreshValue, unsigned int siteThreshTrainSizeseValuet, int siteThresholdBlockType);

// Reads the thresholds from a file and sets the appropriate slots of pwms
void set_siteThresholdsFromFile(char *thresholdsFileName, PWMsVec pwms);

void set_pwmPC(double pc);
