#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "my_types.h"
#include "misc_functions.h"
#include "data_interface.h"
#include "sequenceResample.h"
#include "rand.h"

static chunksSeq duplicateSeqInSetUnion(chunksSeqVec moldSet1, chunksSeqVec moldSet2, int rseq);


chunksSeqVec wholeSeqResampRep(chunksSeqVec moldSet1, chunksSeqVec moldSet2, int nSeqs)
     // Resample nSeqs (entire) sequences from the union of moldSet1 & moldSet2
{
  int iseq;
  chunksSeqVec rSet;

  rSet = alloc_chunksSeqVec(nSeqs);
  for (iseq = 0; iseq < nSeqs; iseq++)
    rSet.entry[iseq] = duplicateSeqInSetUnion(moldSet1, moldSet2, INT_RAND % (moldSet1.len+moldSet2.len));

  return rSet;
}


void wholeSeqResampNoRep(chunksSeqVec moldSet1, chunksSeqVec moldSet2, chunksSeqVec *rSet1, chunksSeqVec *rSet2)
     // Redraw the partition of sequences into the two sets keeping the same number of sequences in each
{
  int iseq, nSeqs, *perm;
  
  *rSet1 = alloc_chunksSeqVec(moldSet1.len);
  *rSet2 = alloc_chunksSeqVec(moldSet2.len);
  nSeqs = moldSet1.len + moldSet2.len;
  assert(perm = (int *) malloc(nSeqs*sizeof(int)));
  perm = rand_perm_prealloc(perm, nSeqs);
  nSeqs = 0;
  for (iseq = 0; iseq < moldSet1.len; iseq++)
    rSet1->entry[iseq] = duplicateSeqInSetUnion(moldSet1, moldSet2, perm[nSeqs++]-1);
  for (iseq = 0; iseq < moldSet2.len; iseq++)
    rSet2->entry[iseq] = duplicateSeqInSetUnion(moldSet1, moldSet2, perm[nSeqs++]-1);
  free(perm);

}


chunksSeq duplicateSeqInSetUnion(chunksSeqVec moldSet1, chunksSeqVec moldSet2, int rseq)
     // Duplicate the sequence referenced by rseq which is indexing into the union of the sets
{

  if (rseq < moldSet1.len)
    return duplicateChunkSeq(moldSet1.entry[rseq]);
  else
    return duplicateChunkSeq(moldSet2.entry[rseq - moldSet1.len]);
}
