typedef struct { // bootstrap blocks
  int pwmID;            // unique PWM identifier: relevant only if the following flag is set
  Boolean bootProtectsSites; // not needed?
  struct blockEntry {
    unsigned int start; // starting position
    unsigned int protectStart; // starting position to ensure no (RC-) site in the original block is chopped
    unsigned int end;   // end position
    int protectEnd;     // end position needed to ensure no site in the original block is chopped
  } *entry;             // the blocks
  int len;              // number of blocks
  int nominalBlockSize; // this is the requested bootstrap block size (not needed?)
} bootBlocksStruct;



void gen_bootBlocksDB(iLetterVec trainData, PWM_Struct pwm, bootBlocksStruct *bootBlocks);

iLetterVec gen_ranBootBlock(iLetterVec trainData, bootBlocksStruct bootBlocks, int len);

void set_bootParms(Boolean bootProtectsSitesValue, int nominalBlockSizeValue);

void free_bootBlocks(bootBlocksStruct *bootBlocks);
