% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LBM.R
\name{LBM_method_select}
\alias{LBM_method_select}
\title{Labeled Bootstrap Maximisation.}
\usage{
LBM_method_select(scores, alpha_range, bs_runs = 50,
  test_methods = c("fds", "mirror", "fds1"), fallback = "fds1",
  input_c = 0.5, max_c = 0.95, rank_scores = NULL, pi_0 = NULL)
}
\arguments{
\item{scores}{A \eqn{(d+1) * m} matrix of combined observed and competing scores. Each column corresponds to a indivdual hypothesis while each row corresponds to an observed or competing score set. The first row is the observed scores while the subsequent rows correspond to specific competing scores.}

\item{alpha_range}{A vector of \eqn{\alpha}, the desired FDR significance levels.}

\item{bs_runs}{The number of bootstrap samples to generate.}

\item{test_methods}{A vector of the names of the parameter selecting methods that we choose between. The order indicates the priority when we break ties.
Possible options: \code{'mirror'} - mirror test (\eqn{c = \lambda = 0.5}), \code{'lf'} - Lei-Fithian choice (\eqn{c = \alpha, \lambda = 0.5}), \code{'fds'} - FDS, \code{'fds1'} - FDS1, \code{'lbm'} - LBM. Default is FDS > mirror > FDS1.}

\item{fallback}{The name of the method that we fall back upon if the estimated maximum FDR is greater than \eqn{\alpha}. Default is FDS1.}

\item{input_c}{Input value of the parameter c that is used in the labeling heuristic. Determines how we select a target win. Lower value results in a stricter condition.}

\item{max_c}{The maximum allowed value of c in the LF, FDS and FDS1 methods. By default this is set of 0.95.}

\item{rank_scores}{A \eqn{(d+1) * m} matrix of ranked observed and competing scores. Same structure as the \code{scores} parameter but with the score ranked across observed-competing sets. Default is NULL which will result in the function caluclating the ranks, but can be manually input.}

\item{pi_0}{An estimate of pi_0. NULL by default in which case it will be caluclated in the function, but can otherwise be manually set.}
}
\value{
Returns a list:
\item{m_choice}{A vector indicating the selected method for each specific \eqn{\alpha}.}
\item{Fallback}{A vector indicating if the fallback was triggered for each specific \eqn{\alpha}.}
}
\description{
Performs Labeled Bootstrap Maximisation (LBM) on a given set of observed and competing scores to select to optimal method of selecting the parameters c and
\eqn{\lambda} for use in multiple competition. Can test a range of FDR significance levels. For more details see section 3.7 in the accompanying paper.
}
\details{
This function internally calls \code{\link{label_heuristic}} to estimate null/alternative labels for each bootstrap samples as well as \code{\link{mirandom}}
to perform multiple-decoy competition. Depending on the chosen \code{test_methods}
this function will call \code{\link{lam_est}}, \code{\link{pi_0_est_St}} and \code{\link{fds_c_select}} to determine c and \eqn{\lambda}.
}
\references{
Emery K, Keich U, Hasam S and Nobel W. (2019) Multiple competition based FDR control. arXiv:1907.01458\cr
\url{https://arxiv.org/abs/1907.01458}
}
\author{
Kristen Emery
}
