% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fds_c_select.R
\name{fds_c_select}
\alias{fds_c_select}
\title{Select the value of the parameter c for use in multiple decoy competition using the Finite Decoy Storey (FDS) procedure.}
\usage{
fds_c_select(obs_scores_pvals, d, pi_0, max_c = 0.95, add = 0, q)
}
\arguments{
\item{obs_scores_pvals}{A vector of p-values for the observed scores. Low p-values correspond to more evidence against the null.}

\item{d}{The number of competing scores for each hypothesis.}

\item{pi_0}{The value of \eqn{\pi_0}, the proportion of true null hypotheses.}

\item{max_c}{The maximum value of c that can be obtained. Default is 0.95.}

\item{add}{Either 0 or 1. Determines if we add 1/(d+1) to the c chosen by the procedure. Set to 1 if using FDS1.}

\item{q}{The value of \eqn{\alpha}, the desired FDR threshold for the Storey test.}
}
\value{
\item{c}{The selected value of c.}
}
\description{
Determines the value of c according the Finite Decoy Storey (FDS) procedure. This procedure sets c equal to the resultant threshold given
by the procedure outlined in Storey, Taylor and Seigmund (2004), specifically equation (6) of the latter reference below.
Can return c for either FDS and FDS1.
For more details see section 3.6 of the accompanying paper (the former reference below).
}
\references{
Emery K, Keich U, Hasam S and Nobel W. (2019) Multiple competition based FDR control. arXiv:1907.01458\cr
\url{https://arxiv.org/abs/1907.01458}

Storey JD, Taylor JE, and Siegmund D. (2004) Strong control,
conservative point estimation, and simultaneous conservative
consistency of false discovery rates: A unified approach. Journal of
the Royal Statistical Society, Series B, 66: 187-205. \cr
\url{http://onlinelibrary.wiley.com/doi/10.1111/j.1467-9868.2004.00439.x/abstract}
}
\author{
Kristen Emery
}
