% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_heuristic.R
\name{label_heuristic}
\alias{label_heuristic}
\title{Draw conjectured null and alternative labels for a set of hypotheses.}
\usage{
label_heuristic(scores, c, rank_scores = NULL)
}
\arguments{
\item{scores}{A \eqn{(d+1) * m} matrix of combined observed and competing scores. Each column corresponds to a indivdual hypothesis while each row corresponds to an observed or competing score set. The first row is the observed scores while the subsequent rows correspond to specific competing scores.}

\item{c}{Input value of the parameter c. Determines how we select a observed win. Lower value results in a stricter condition.}

\item{rank_scores}{A \eqn{(d+1) * m} matrix of ranked observed and competing scores. Same structure as the \code{scores} parameter but with the score ranked across observed-competing sets. Default is NULL which will result in the function caluclating the ranks, but can be manually input.}
}
\value{
\item{estTrueNullInds}{A vector of labels for each hypothesis indicating whether a specific hypothesis was estimated as truly null. 1 = Null, 0 = Alternative.}
}
\description{
Draws a set of conjectured null and alternative labels for use in segmented resampling.
Calculates a W and L score for each hypothesis according to the mirandom mapping scheme with c pre-selected and \eqn{\lambda = c}.
Labels are determined by estimating the number of false discoveries in each segment and randomly assigning labels to hypotheses in that segment weighted by the empirical p-values.
For more details see section 3.7 and supplementary section 6.5 of the accompanying paper.
}
\references{
Emery K, Keich U, Hasam S and Nobel W. (2019) Multiple competition based FDR control. arXiv:1907.01458\cr
\url{https://arxiv.org/abs/1907.01458}
}
\author{
Kristen Emery & Uri Keich
}
