% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multidecoy_fdr.R
\name{mirandom}
\alias{mirandom}
\title{FDR control using multiple competition.}
\usage{
mirandom(scores, c, lambda, alpha, rank_scores = NULL)
}
\arguments{
\item{scores}{A \eqn{(d+1) * m} matrix of combined observed and competing scores. Each column corresponds to a indivdual hypothesis while each row corresponds to a observed or competing score set. The first row is the observed scores while the subsequent rows correspond to specific competing scores.}

\item{c}{Input value of the parameter c. Determines how we select a observed win. Lower value results in a stricter condition.}

\item{lambda}{Input value of the parameter \eqn{\lambda}. Determines how we select a competing win. Higher value results in a stricter condition.}

\item{alpha}{The desired FDR significance level.}

\item{rank_scores}{A \eqn{(d+1) * m} matrix of ranked observed and competing scores. Same structure as the \code{scores} parameter but with the score ranked across observed-competing score sets. Default is NULL which will result in the function calculating the ranks, but can be manually input.}
}
\value{
Returns a list:

\item{Discoveries}{The W values of the selected discoveries.}
\item{Discoveries_ind}{The indicies (location) of the selected discoveries. A response of 0 corresponds to no discoveries.}
}
\description{
Performs multiple competition with a preselected value of c and \eqn{\lambda}. Uses the mirandom mapping scheme to determine W and L.
For more details see sections 3.2 - 3.5 of the accompanying paper.
}
\details{
\code{rank_scores} can be pre-calculated and input so we don't have perform m iterations of ranking every time we consider a new \eqn{\alpha}
}
\references{
Emery K, Keich U, Hasam S and Nobel W. (2019) Multiple competition based FDR control. arXiv:1907.01458\cr
\url{https://arxiv.org/abs/1907.01458}
}
\author{
Kristen Emery & Uri Keich
}
