% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicomp.R
\docType{package}
\name{multicomp}
\alias{multicomp}
\alias{multicomp-package}
\title{Multiple competition based FDR control.}
\description{
This package implements multiple competition procedures to control the false discovery rate (FDR) in multiple hypotheses testing.
These procedures forgoe the use of p-values and instead use direct competition between the observed scores and a set of pre-generated null scores for each hypothesis.
}
\section{Outline}{

Multiple competition allows for p-value free multiple hypothesis testing. By (externally) randomly generating sets of
null scores for each hypothesis and directly comparing these to the original observed scores we are able to estimate and
control the false discovery rate (FDR) for a given list of discoveries. These discoveries are generally a subset of the hypotheses for which the original scores are
"better" than their corresponding competing null scores.

The procedure extends the competition framework of target-decoy competition and knockoff+ to utilize
multiple competing scores instead of just one. This can yield significant power gain without sacrificing FDR control.
}

\section{Functions}{

The functions can be separated into two levels; a primary level that is suitable for most users who are simply interested in application
and a secondary level for more advanced users looking for more control.

Primary level:
\itemize{
\item{\code{\link{multidecoy_comp}}: The main function of this package. Takes a set of observed scores and
competing null scores and returns a list of discoveries. Most users will use this function only.}
}

Secondary level:

\itemize{
\item{\code{\link{mirandom}}: Our general procedure for multiple competition based FDR control. Depends on a preselected pair of tuning parameters \eqn{c} and \eqn{\lam} (see accompanying paper)}
\item{\code{\link{fds_c_select}}: Calculates the parameter \eqn{c}, a threshold determining what is defined as an original score win, according the
Finite Decoy Storey (FDS) formulation.}
\item{\code{\link{lam_est}}: Calculates \eqn{\lambda},  threshold determining what is defined as a competing null score win.}
\item{\code{\link{LBM_method_select}}: Selects the method of choosing \eqn{c} and \eqn{\lambda} using a bootstrap approach.}
\item{\code{\link{label_heuristic}}: Estimates null and alternative labels for the data for construction of
the bootstrap samples in LBM.}
\item{\code{\link{pi_0_est_St}}: Estimates \eqn{\pi_0} according to Storey, Taylor and Tibshirani's (2004) formulation (equation (4) in that paper).}

}
}

\references{
Emery K, Keich U, Hasam S and Nobel W. (2019) Multiple competition based FDR control. arXiv:1907.01458\cr
\url{https://arxiv.org/abs/1907.01458}

Storey JD, Taylor JE, and Siegmund D. (2004) Strong control,
conservative point estimation, and simultaneous conservative
consistency of false discovery rates: A unified approach. Journal of
the Royal Statistical Society, Series B, 66: 187-205. \cr
\url{http://onlinelibrary.wiley.com/doi/10.1111/j.1467-9868.2004.00439.x/abstract}
}
