% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multidecoy_comp.R
\name{multidecoy_comp}
\alias{multidecoy_comp}
\title{Multiple competition with parameter selection.}
\usage{
multidecoy_comp(obs_scores, decoy_scores, alpha_range = c(0.05),
  c_lam_selection = "lbm", ...)
}
\arguments{
\item{obs_scores}{The vector of the observed scores.}

\item{decoy_scores}{A \eqn{d * m} matrix of the corresponding competiting null scores. Each column corresponds to a specific hypothesis/observed score. Each row corresponds to a single competing set.}

\item{alpha_range}{A vector of \eqn{\alpha}, the FDR thresholds, that we wish to test at. Default tests at \eqn{\alpha = 0.05} only.}

\item{c_lam_selection}{Method of choosing the parameters c and \eqn{\lambda}.
Possible options: \code{'mirror'} - mirror test (\eqn{c = \lambda = 0.5}), \code{'lf'} - Lei-Fithian choice (\eqn{c = \alpha, \lambda = 0.5}), \code{'fds'} - FDS, \code{'fds1'} - FDS1, \code{'lbm'} - LBM.}

\item{...}{Extra parameters to be passed to \code{LBM method select} (if \code{c_lam_selection = "LBM"}). Allows more advanced users more control over the LBM procedure. See \code{\link{LBM_method_select}} for more details.}
}
\value{
Returns a list showing the indicies of the discoveries. Each entry in the list corresponds to the discovery vector for a specific value of \eqn{\alpha} in alpha_range. A response of 0 corresponds to no discoveries.
}
\description{
Performs multiple competition on a given set of observed scores and corresponding competing null scores and returns the discovery list.
By default this function selects the tuning parameters \eqn{c} and \eqn{\lambda} using LBM (see accompanying paper) though it can be set to utilize other procedures.
Can test a range of FDR significance levels simultaneously.
}
\details{
This is a function that combines parameter selection with mulitple competition using a \code{\link{mirandom}} mapping scheme (which it calls internally once parameters have been selected) to obtain the discovery list.
Depending on the parameter method chosen (either FDS or FDS1) \code{\link{lam_est}}, \code{\link{fds_c_select}} and \code{\link{pi_0_est_St}} are called internally to calculate \eqn{\lambda} and  \eqn{c} and estimate \eqn{\pi_0} repectively.
If lbm is the selected parameter method then \code{\link{LBM_method_select}} is called to determine the optimal method of selecting c and \eqn{\lambda} for each \eqn{\alpha}.
The procedure will then apply the chosen method to acquire the discoveries. The parameters \code{bs_runs}, \code{test_methods} and \code{fallback} are not used unless \code{c_lam_selection = 'lbm'} and can be left as default.
}
\examples{
m = 200; k = 20; d = 5; alpha_range = c(0.01,0.05,0.1,0.2)
null_mu = rep(0, m); mu = null_mu; sig = rep(2, m)
alts = sample(m, k)
mu[alts] = 5
obs_scores = rnorm(m,mu,sig)
#Rows correspond to decoy sets, columns correspond to hypotheses.
decoy_scores = matrix(rnorm(m*d,null_mu,sig), ncol = m, nrow = d, byrow = TRUE)

#Basic usage of multidecoy_comp with the LBM method:
results = multidecoy_comp(obs_scores, decoy_scores, alpha_range, c_lam_selection = 'lbm')
print(results)

}
\references{
Emery K, Keich U, Hasam S and Nobel W. (2019) Multiple competition based FDR control. arXiv:1907.01458\cr
\url{https://arxiv.org/abs/1907.01458}
}
\author{
Kristen Emery
}
